/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.user.security;

import com.tp_link.eap.domain.account.Role;
import com.tp_link.eap.domain.account.User;
import com.tp_link.eap.user.service.PrivilegeServiceI;
import com.tp_link.eap.user.service.UserService;
import java.util.Collection;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="userRealm")
public class UserRealm
extends AuthorizingRealm {
    private Logger a = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private UserService b;
    @Autowired
    private PrivilegeServiceI c;

    public UserService getUserService() {
        return this.b;
    }

    public void setUserService(UserService userService) {
        this.b = userService;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        UsernamePasswordToken usernamePasswordToken = (UsernamePasswordToken)authcToken;
        User user = this.b.getUserByName(usernamePasswordToken.getUsername());
        return new SimpleAuthenticationInfo((Object)user.getName(), (Object)user.getPassword(), this.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        this.a.debug("user realm , authorization.");
        Collection collection = principals.fromRealm(this.getName());
        if (collection.isEmpty()) {
            return null;
        }
        String string = (String)collection.iterator().next();
        User user = this.b.getUserByName(string);
        if (user != null) {
            SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
            Role role = user.getRole();
            simpleAuthorizationInfo.addRole(role.getName());
            simpleAuthorizationInfo.addStringPermissions((Collection)role.getPermissions());
            return simpleAuthorizationInfo;
        }
        return null;
    }
}

